from math import *

def point_x(pt):
	return pt[0]
	
def point_y(pt):
	return pt[1]

def point_z(pt):
	return pt[2]
	
def point_add(pt1, pt2):
	return [point_x(pt1)+point_x(pt2), point_y(pt1)+point_y(pt2), point_z(pt1)+point_z(pt2)]

def point_sub(pt1, pt2):
	return [point_x(pt1)-point_x(pt2), point_y(pt1)-point_y(pt2), point_z(pt1)-point_z(pt2)]

def dot_product(pt1,pt2):
	return point_x(pt1)*point_x(pt2) + point_y(pt1)*point_y(pt2) + point_z(pt1)*point_z(pt2)

def cross_product(pt1,pt2):
	return [point_y(pt1)*point_z(pt2) - point_z(pt1)*point_y(pt2), point_z(pt1)*point_x(pt2) - point_x(pt1)*point_z(pt2), point_x(pt1)*point_y(pt2) - point_y(pt1)*point_x(pt2)]

def vector_length(v):
	return math.sqrt(dot_product(v,v))
	
def aabb_min(aabb):
	return aabb[0]

def aabb_max(aabb):
	return aabb[1]
	
def aabb_diag_length(aabb):
	return vector_length(point_sub(aabb_max(aabb), aabb_min(aabb)))

def point_in_aabb(aabb, pt):
	min = aabb_min(aabb)
	max = aabb_max(aabb)
	for i in [0,1,2]:
		if pt[i] < min[i]:
			return False
		if pt[i] > max[i]:
			return False
	return True


	